//
//  YHFamilyInfoWarmTipsView.swift
//  galaxy
//
//  Created by edy on 2024/8/16.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHFamilyInfoWarmTipsView: UIView {

    lazy var blackMaskView: UIView = {
        let view = UIView()
        view.backgroundColor = .alertMaskColor
        let tap = UITapGestureRecognizer(target: self, action: #selector(dismiss))
        view.addGestureRecognizer(tap)
        return view
    }()
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.textAlignment = .center
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.textColor = UIColor.mainTextColor
        label.text = "温馨提示"
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var detail1Label: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("电子签证缴费截止日期：", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("一般为正式获批信下发后", .font(UIFont.PFSC_R(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let c: ASAttributedString = .init("3个月内", .font(UIFont.PFSC_B(ofSize: 15)),.foreground(UIColor.brandMainColor))
        let d: ASAttributedString = .init("(请以获批函规定日期为准)", .font(UIFont.PFSC_R(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c+d
        return label
    }()
    
    lazy var detail2Label: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        label.font = UIFont.PFSC_R(ofSize: 14.0)
        let a: ASAttributedString = .init("赴港激活截止日期：", .font(UIFont.PFSC_M(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("一般为电子签证缴费后", .font(UIFont.PFSC_R(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let c: ASAttributedString = .init("3个月内", .font(UIFont.PFSC_B(ofSize: 15)),.foreground(UIColor.brandMainColor))
        let d: ASAttributedString = .init("(请以缴费后电子签证详情为准)，入境香港即代表激活", .font(UIFont.PFSC_R(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        label.attributed.text = a+b+c+d
        return label
    }()
    
    lazy var detail3Label: UILabel = {
        var label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("更多详情可点击页面上方", .font(UIFont.PFSC_R(ofSize: 15)),.foreground(UIColor.mainTextColor(alpha: 0.7)))
        let b: ASAttributedString = .init("《香港身份获批操作指引》", .font(UIFont.PFSC_B(ofSize: 15)),.foreground(UIColor.brandMainColor))
        label.attributed.text = a+b
        return label
    }()
    
    lazy var confirmBtn: UIButton = {
        let button = UIButton()
        button.titleLabel?.font = UIFont.PFSC_R(ofSize: 14)
        button.setTitle("好的", for: .normal)
        button.setTitleColor(UIColor.white, for: .normal)
        button.backgroundColor = .brandMainColor
        button.addTarget(self, action: #selector(didConfirmBtnClicked), for: .touchUpInside)
        button.layer.cornerRadius = kCornerRadius3
        return button
    }()
    
    static func tipsView() -> YHFamilyInfoWarmTipsView {
        let view = YHFamilyInfoWarmTipsView(frame: UIScreen.main.bounds)
        return view
    }
    
    @objc func show() {
        UIApplication.shared.yhKeyWindow()?.addSubview(self)
    }
    
    @objc func dismiss() {
        self.removeFromSuperview()
    }
    
    @objc func didConfirmBtnClicked() {
        self.dismiss()
    }
    
    required init?(coder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        createUI()
    }
    
    func createUI() {
        
        self.addSubview(blackMaskView)
        self.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(detail1Label)
        whiteContentView.addSubview(detail2Label)
        whiteContentView.addSubview(detail3Label)
        whiteContentView.addSubview(confirmBtn)
        
        blackMaskView.snp.makeConstraints { make in
            make.edges.equalToSuperview()
        }
        
        whiteContentView.snp.makeConstraints { make in
            make.left.equalTo(38)
            make.right.equalTo(-38)
            make.centerY.equalToSuperview()
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.height.equalTo(24)
            make.left.equalTo(21)
            make.right.equalTo(-21)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.height.equalTo(0.5)
            make.left.equalTo(0)
            make.right.equalTo(0)
        }
        
        detail1Label.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(lineView.snp.bottom).offset(16)
        }
        
        detail2Label.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(detail1Label.snp.bottom).offset(16)
        }
        
        detail3Label.snp.makeConstraints { make in
            make.left.equalTo(21)
            make.right.equalTo(-21)
            make.top.equalTo(detail2Label.snp.bottom).offset(16)
        }
        
        confirmBtn.snp.makeConstraints { make in
            make.top.equalTo(detail3Label.snp.bottom).offset(21)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(-16)
            make.height.equalTo(45)
        }
    }

}
